function output = nonlinear_IRF_VSTAR_IV_rirf(results,y,x,transvar,param_setting)
% PURPOSE: generates GIRF for a non-linear multivariate Vector STAR model
% based on Koop et al. 1996 and Weise 1999
% ########################################################################
% (*) regressor structure has to be adjusted manually
% (**) translag and transpos has to be adjusted manually (case of 2
% transition variables)
% ########################################################################
%-------------------------------------------------------------------------
% Definition (Koop et al. 1996):
% The Generalized Impulse Response Function  is designed to solve the
% problems categorized above. The problem of treatment of the future is dealt with
% by using the expectation operator conditioned on only the history and/or shock.
% That is, the future shocks are averaged out. Thus, the response constructed is an
% average of what might happen given the present and past. The natural baseline
% for the impulse response function is then defined as the conditional expectations,
% given only the history.
%-------------------------------------------------------------------------
% USAGE:  result = stvar(results,y,x,transvar,param_setting), where

% results:          structure given by ...
% y:                dependent variables
% x:                regressor matrix
% transvar:         transition variable(s)
% param_setting:    [R,B,hist,q,nlag,trans,transvar,shockv,shock]

% R -- R-repetitions for the Monte Carlo integration  to allow for an
%      accurate estimation of GIRF random vector, GIRF is treated as a random
%       variable
%       a non-linear multivariate model requires Monte Carlo integration
%       idea: computing the conditional expectations in the GI function
%       by means of Monte Carlo integration
%       Repeat all steps a sufficient number of times to allow accurate estimation
%       of aspects of interest of the GI random vector. Again, as the number of
%       repetitions increases pointwise convergence will be guaranteed by the Law of
%       Large Numbers.
% B --  simulation for a particular history, B=100 is recommended in Koop
%       et al (1996)
%       As B-->inf by the Law of Large Numbers these averages across individual
%       Monte Carlo replications will converge to the conditional expectations
% hist -- Pick a history - condition on a  histrory, history treated as a random
%         variable
%         hist == 1 if both transition variables >= thresh, hist==0 if both
%         transition variables <thresh 
% q --  length of GIRF horizon, shock takes place in period 0 and responses
%       are computed for q periods after
% nlag -- (maximum) lag length
% translag -- lag length of transition variable(s)
% trans_pos -- position of transition variable in y (equation)
% shockv --  variable of y being shocked (column of y)
% shock --  the standard deviation shocks (1 = one std dev shock)
% const -- constant (1==yes, 0=no)

%-------------------------------------------------------------------------
% written by
% Frauke Schleer
% schleer@zew.de
%-------------------------------------------------------------------------

% initialize parameter setting

R   = param_setting(1);
B   = param_setting(2);
hist   = param_setting(3);
q   = param_setting(4);
nlag   = param_setting(5);
maxlag   = param_setting(6);
translag = param_setting(7);
trans_pos = param_setting(8);
shockv = param_setting(9);
shock = param_setting(10);
const= param_setting(11);
country='Germany';
%#################### adjust if more than one transition variable #######
%  translag=[1 2]; 
%  trans_pos=[1 2]; 
%#########################################################################


dep=y(nlag+1:end,:);
[nobs,neqs]=size(dep);

% initialize transition function and parameters

[junk,neqs_trans]=size(transvar);
std_trans=std(transvar);
g_func(nobs,neqs_trans)=0;
thresh(neqs_trans,1)=0; smooth(neqs_trans,1)=0;

for j=1:neqs_trans % be carefull with parameter setting if more than 1 transition function
    % and in which order / matrix notation are parameters saved in results
    % file
    thresh(j,1)=results.param(1,j);
    smooth(j,1)=results.param(2,j);
    g_func(:,j) = (1+exp(-smooth(j)/std_trans(j)*(transvar(:,j)-thresh(j)))).^(-1);
end

% initialize regressors and coefficients
coeffs=results.beta;
nvar_struc=results.nvar_struc;

regs_lin(neqs).eq=0;
regs_nonlin(neqs).eq=0;

counter=1;
%%%%%%%for n=1:2:2*neqs
for n=1:2:2*neqs
    regs_lin(counter).eq=x{:,n};
    regs_nonlin(counter).eq=x{:,n+1};
    counter=counter+1;
end

% initialize residuals
resids=results.resid;

% estimated variance covariance matrix
Omega = (resids'*resids)/length(resids);
P=chol(Omega)';  % yields a lower triangular matrix

% uncorrelated and unit variance components (orthogonal innovations)
omega=P^-1*resids';
omega=omega';

% linear IRF are based on   IRF(.) = psi*P; where psi is retrieved from
% coeffs (see irf.m)

%start Monte Carlo integration

%initialite GIRFs

GIRF_R(q+1,R*neqs)=0;
GIRF_B(q+1,neqs)=0;

paths_temp(q+1,B*neqs)=0;
paths_s_temp(q+1,B*neqs)=0;

for r=1:neqs:R*neqs
    
    %###### assume on transition function governing the whole system ######
    %------------------------------------------------------------------------
    %Step 1: pick a history based on thresh
    % Pick a history - condition on a  histroy, histroy treated as a random
    % variable
    %------------------------------------------------------------------------
    
    % hist == 1 if transition variable >= thresh, hist==0 else
        
    if neqs_trans==1
        
        temp=randi([translag+1,nobs-q]); % define appropriate range
        
        if hist==1
            while    transvar(temp,1)<thresh 
                temp=randi([translag+1,nobs-q]);
            end % exits the while loop as soon as transvar is greater than thresh
            hist_choice=temp;
        else
            while    transvar(temp,1)>=thresh
                temp=randi([translag+1,nobs-q]);
            end
            hist_choice=temp;
        end
        
    else
        translag_max=max(translag);
        temp=randi([translag_max+1,nobs-q]); % define appropriate range
        
        if hist==1
            while    transvar(temp,1)<thresh(1) && transvar(temp,2)<thresh(2)
                temp=randi([translag_max+1,nobs-q]);
            end % exits the while loop as soon as transvar is greater than thresh
            hist_choice=temp;
        else
            while    transvar(temp,1)>=thresh(1) && transvar(temp,2)>=thresh(2)
                temp=randi([translag_max+1,nobs-q]);
            end
            hist_choice=temp;
        end
        
    end
    
    
    % initialize paths to be stored
    paths=zeros(q+1,B*neqs);
    paths_s=zeros(q+1,B*neqs);
    

       
    for b=1:neqs:B*neqs % repeat steps 2:4 which is simulation for a particular history
        
        %------------------------------------------------------------------------
        %Step 2: pick a shock sequence
        % Pick a sequence of shocks: future shocks cannot be set zero as in the
        % lineaer case, but future shocks must be drawn from some distribution and
        % their effects averaged out over a large number od draws --> use bootstrap
        % methods
        %------------------------------------------------------------------------
        
        % apply 1a)ii)A) from Koop et al. (1996)
        % transform observed residuals to contemporaneous independence
        % this creates a sample size of neqs*nobs to bootstrap from
        
        [omega_bs] = bootstrp(1,'equal',omega) ; % which is a draw with replacement
        % resamples columnwise such that the column-element which belong
        % together (in time dimension) stick together --> Tx1 index of
        % integers
        omega_bs=reshape(omega_bs,nobs,neqs);
        % shocks are aussmed to be jointly distibuted, so if data t's shock is
        % drwan all k residulas for date t are collected (Weise, 1999)
        %omega_bs_{t+n},n=0,...,q; t=hist_choice; --> this is done in the
        %t-loop for the history
        %omega_bs=omega_bs(hist_choice:hist_choice+q+1,:);
        
        omega_bs_s=omega_bs;
       % omega_bs_s(hist_choice,shockv)=omega_bs_s(hist_choice,shockv)+shock/(Omega(shockv,shockv)^(1/2));  % shock is equal to 1/std dev.
       % omega_bs_s(hist_choice,shockv)=shock; 
       % omega_bs(hist_choice,shockv)=0; 
       % omega_bs_s(hist_choice,shockv)=omega_bs_s(hist_choice,shockv)+shock;
       % is a one std dev shock, since omega_bs has unit variance by
       % choleski decompisition
       %----------------------------------------------------------------
       % check what happens if instead of avergaing set all other a shut down  
       % omega_bs_s(hist_choice+1:hist_choice+q,shockv)=0;
       % omega_bs(hist_choice+1:hist_choice+q,shockv)=0;        
       %----------------------------------------------------------------
       % returning dependence to shocks-> have to redefine it back since we
       % trace the shock through the system (we do not adjust coefficients)
        v_bs  = (P*omega_bs')'; % no shock
        v_bs_s = (P*omega_bs_s')'; % shocked
       %----------------------------------------------------------------
        v_bs_s(hist_choice,shockv)=shock;
        v_bs(hist_choice,shockv)=0;
       %----------------------------------------------------------------
        v_t  = [v_bs v_bs_s ];
        
        path=dep; % path for the non-shocked GIRF
        path_s=dep; % path for the shocked IRF case
        
        % initialize variables for the shocked case
        %transvar_s=transvar;
        
        g_func_path_s=g_func;
        g_func_path=g_func;
        
        regs_lin_path=regs_lin;
        regs_nonlin_path=regs_nonlin;
        regs_lin_path_s=regs_lin;
        regs_nonlin_path_s=regs_nonlin;
        
        %Iterating on series --> evolution of time series
        % shock takes place in period 0 and responses are computed for q
        % periods after : hist-choice is equal to period 0 and the q
        % periods further
        for t=hist_choice:hist_choice+q %
            
           % ### simulate paths ####
           % counter=0;
            counter_nvar_eq=0;
            for j=1:neqs
                
                nvar_eq=sum(nvar_struc(j,:));
                % assign equation-specifc transition function
                if neqs_trans==1
                    g_func_temp_path=g_func_path(:,1);
                    g_func_temp_path_s=g_func_path_s(:,1);
                else 
                    g_func_temp_path=g_func_path(:,j);
                    g_func_temp_path_s=g_func_path_s(:,j);
                end
                transfunc=g_func_temp_path(:,ones(1,(nvar_struc(j,2)+const)));
                transfunc_s=g_func_temp_path_s(:,ones(1,(nvar_struc(j,2)+const)));
                
                if const==1
                    % without shock
                    path(t,j)= [ones(1,1) regs_lin_path(j).eq(t,:) [ones(1,1) regs_nonlin_path(j).eq(t,:)].*transfunc(t,:)]*coeffs(counter_nvar_eq+1:counter_nvar_eq+nvar_eq+const*2)+ v_t(t,j);
                    % with shock
                    path_s(t,j)= [ones(1,1) regs_lin_path_s(j).eq(t,:) [ones(1,1) regs_nonlin_path_s(j).eq(t,:)].*transfunc_s(t,:)]*coeffs(counter_nvar_eq+1:counter_nvar_eq+nvar_eq+const*2)+ v_t(t,neqs+j);
                else
                    % without shock
                    path(t,j)= [regs_lin_path(j).eq(t,:) regs_nonlin_path(j).eq(t,:).*transfunc(t,:)]*coeffs(counter_nvar_eq+1:counter_nvar_eq+nvar_eq+const*2)+ v_t(t,j);
                    % with shock
                    path_s(t,j)= [ regs_lin_path_s(j).eq(t,:) regs_nonlin_path_s(j).eq(t,:).*transfunc_s(t,:)]*coeffs(counter_nvar_eq+1:counter_nvar_eq+nvar_eq+const*2)+ v_t(t,neqs+j);
                    
                end
                %counter=counter+2;
                counter_nvar_eq=counter_nvar_eq+nvar_eq+const*2;
                
            end
            
            %updating gy matrix with the values just obtained-> iterating
            %on the non-linear time series model
            for j=1:neqs_trans
                % update transition variable
                %transvar(t,j)=path(t-translag(j),trans_pos(j));
                %transvar_s(t,j)=path_s(t-translag(j),trans_pos(j));
                % update transition function
                g_func_path(t,j) = (1+exp(-smooth(j)/std_trans(j)*(path(t-translag(j),trans_pos(j))-thresh(j))))^(-1);
                g_func_path_s(t,j) = (1+exp(-smooth(j)/std_trans(j)*(path_s(t-translag(j),trans_pos(j))-thresh(j))))^(-1);
            end
            
            dep_temp=[y(1:nlag,:);path];
            dep_temp_s=[y(1:nlag,:);path_s]; 
            
            % regressor structure has to be adjusted manually
            
            %#########################################################################
            % results based on stvar_est_ho_2013.m
            %#########################################################################
%              sel=results.opt_val_lagstr.*repmat((1:(maxlag*neqs))',[1,neqs,2]);
% %             
%             lagstr1_lin=find(sel(:,1,1));
%             lagstr1_nonlin=find(sel(:,1,2));
%             lagstr2_lin=find(sel(:,2,1));
%             lagstr2_nonlin=find(sel(:,2,2));
%              
%             ylag1=trimr(mlag(dep_temp,maxlag),nlag,0);
%             regs_lin_path(1).eq=ylag1(:,lagstr1_lin');
%             regs_lin_path(2).eq=ylag1(:,lagstr2_lin');
%             regs_nonlin_path(1).eq=ylag1(:,lagstr1_nonlin');
%             regs_nonlin_path(2).eq=ylag1(:,lagstr2_nonlin');
%             
%             ylag2=trimr(mlag(dep_temp_s,maxlag),nlag,0);
%             regs_lin_path_s(1).eq=ylag2(:,lagstr1_lin');
%             regs_lin_path_s(2).eq=ylag2(:,lagstr2_lin');
%             regs_nonlin_path_s(1).eq=ylag2(:,lagstr1_nonlin');
%             regs_nonlin_path_s(2).eq=ylag2(:,lagstr2_nonlin');
% %             
            %#########################################################################
            % results based on full lagstructure
            %#########################################################################
%             
            regs_lin_path(1).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_lin_path(2).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_lin_path(3).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_lin_path(4).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_lin_path(5).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_nonlin_path(1).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_nonlin_path(2).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_nonlin_path(3).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_nonlin_path(4).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            regs_nonlin_path(5).eq=trimr(mlag(dep_temp,nlag),nlag,0);
            
            regs_lin_path_s(1).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_lin_path_s(2).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_lin_path_s(3).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_lin_path_s(4).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_lin_path_s(5).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_nonlin_path_s(1).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_nonlin_path_s(2).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_nonlin_path_s(3).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_nonlin_path_s(4).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            regs_nonlin_path_s(5).eq=trimr(mlag(dep_temp_s,nlag),nlag,0);
            
            %#########################################################################
            % results based on stvar_est_ML_withoutlagstruc.m
%             %#########################################################################
%               lagstr1=[1 2 3 18];
%               lagstr2=[17 18 21 28 29 30];
%               
%             ylag1=trimr(mlag(dep_temp,maxlag),nlag,0);
%             regs_lin_path(1).eq=ylag1(:,lagstr1');
%             regs_lin_path(2).eq=ylag1(:,lagstr2');
%             regs_nonlin_path(1).eq=ylag1(:,lagstr1');
%             regs_nonlin_path(2).eq=ylag1(:,lagstr2');
%             
%             ylag2=trimr(mlag(dep_temp_s,maxlag),nlag,0);
%             regs_lin_path_s(1).eq=ylag2(:,lagstr1');
%             regs_lin_path_s(2).eq=ylag2(:,lagstr2');
%             regs_nonlin_path_s(1).eq=ylag2(:,lagstr1');
%             regs_nonlin_path_s(2).eq=ylag2(:,lagstr2');
            
        end
        
        paths(:,b:b+neqs-1)=path(hist_choice:hist_choice+q,:);
        paths_s(:,b:b+neqs-1)=path_s(hist_choice:hist_choice+q,:);
    end
    
    
    counter=0;
    for j=1:neqs
        indx=j:neqs:B*neqs;
        paths_temp(:,1+counter:B+counter)=paths(:,indx);
        paths_s_temp(:,1+counter:B+counter)=paths_s(:,indx);
        GIRF_B(:,j)=mean(paths_s(:,indx),2)- mean(paths(:,indx),2);
        counter=counter+B;
    end
    
    GIRF_R(:,r:r+neqs-1)=GIRF_B;
    
end

% Calculation 90% confidence bands by using the empirical distrubition
% function

inf(q+1,neqs)=0;
sup(q+1,neqs)=0;

mean_GIRF(q+1,neqs)=0;
GIRF_R_sorted=[];
for j=1:neqs
    for t=1:q+1
        indx=j:neqs:R*neqs;
        [prob ,val] = ecdf(GIRF_R(t,indx));
        inf(t,j)=val(min(find(prob>0.05)));
        sup(t,j)=val(min(find(prob>=0.95)-1));        
    end
    mean_GIRF(:,j)=mean(GIRF_R(:,indx),2);
    GIRF_R_sorted=[GIRF_R_sorted GIRF_R(:,indx)];
    output.GIRF(j).eq=[inf(:,j)  mean_GIRF(:,j) sup(:,j)];
    output.GIRFcum(j).eq=[cumsum(inf(:,j))  cumsum(mean_GIRF(:,j)) cumsum(sup(:,j))];
end

% creating the output structure
output.GIRF_R=GIRF_R_sorted; % for construction the boxplot


if hist==1
    name_hist='high stress';
else
   name_hist='low stress';
end

if shockv==4
    name_shockv='EONIA';
else
   name_shockv='FCI';
end

shock_std=num2str(shock);

%figure(1)
% fig1=figure;
% subplot(2,1,1); boxplot(GIRF_R_sorted(:,1:R)','Whisker',.45,'symbol','','medianstyle','target');
% set(gca,'XTick',1:19);
% set(gca,'XTickLabel',{'0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18'})
% title(sprintf('IRF of IP - %sstdev. shock in %s, %s', ...
%         sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)));
% %title('IRF of FCI - shock in' sprintf(name_shockv),sprintf(name_hist))
% subplot(2,1,2); boxplot(GIRF_R_sorted(:,R+1:end)','Whisker',.45,'symbol','','medianstyle','target');
% set(gca,'XTick',1:19);
% set(gca,'XTickLabel',{'0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18'})
% %title('IRF of IP')
% title(sprintf('IRF of FCI - %sstdev. shock in %s, %s', ...
%         sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)));
% saveas(fig1,sprintf('GIRF of %s, %s shock in %s, %s',sprintf(country),sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)),'png'); %name is a string
% %1.282 sigma cotain 80% by following formula 1.292=0.6745+w*IQD
% %(2*0.6745sigma) we get w 0.45 
% http://en.wikipedia.org/wiki/File:Boxplot_vs_PDF.svg

% GIRF_R_sorted_cum=cumsum(GIRF_R_sorted);
% %figure(2)
% fig1=figure;
% subplot(2,1,1); boxplot(GIRF_R_sorted_cum(:,1:R)','Whisker',.45,'symbol','','medianstyle','target');
% set(gca,'XTick',1:19);
% set(gca,'XTickLabel',{'0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18'})
% title(sprintf('Cum. IRF of IP - %sstdev. shock in %s, %s', ...
%         sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)));
% subplot(2,1,2); boxplot(GIRF_R_sorted_cum(:,R+1:end)','Whisker',.45,'symbol','','medianstyle','target');
% set(gca,'XTick',1:19);
% set(gca,'XTickLabel',{'0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18'})
% title(sprintf('Cum. IRF of FCI - %sstdev. shock in %s, %s', ...
%         sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)));
% saveas(fig1,sprintf('GIRFcum of %s, %s shock in %s, %s',sprintf(country),sprintf(shock_std),sprintf(name_shockv), sprintf(name_hist)),'png'); %name is a string


%PD = fitdist(GIRF_R(2,indx)','kernel')

